/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;

public final class zz2B
implements DataInput,
DataOutput {
    private RandomAccessFile zz2O;
    private long zz2N;
    private byte[] buffer;
    private long zz2M;
    private long zz2L;
    private int zz2K;
    private boolean zz2J;
    private int mode;
    private boolean zz2I = false;

    private zz2B(String string, String string2) throws IOException {
        this(string, string2, 4096);
    }

    private zz2B(String string, String string2, int n) throws IOException {
        this(string, "r".equals(string2) ? 1 : ("rw".equals(string2) ? 3 : 0), 4096);
    }

    public zz2B(File file, String string) throws IOException {
        this(file.getPath(), string);
    }

    private zz2B(String string, int n, int n2) throws FileNotFoundException, IOException {
        this.mode = n;
        if ((this.mode & 4) > 0) {
            this.mode |= 2;
        }
        File file = new File(string);
        if ((this.mode & 2) > 0) {
            file.exists();
        }
        if ((this.mode & 4) > 0 && file.exists() && !file.delete()) {
            throw new IOException("Failed to delete " + string);
        }
        if (this.mode == 1 && !new File(string).exists()) {
            throw new FileNotFoundException(string);
        }
        String string2 = (this.mode & 2) > 0 ? "rw" : "r";
        this.zz2O = new RandomAccessFile(string, string2);
        this.zz2M = 0L;
        this.zz2L = 0L;
        this.zz2K = 0;
        this.zz2N = 0L;
        this.buffer = new byte[n2];
        this.zz2J = false;
    }

    public final void close() throws IOException {
        try {
            if ((this.mode | 2) > 0 && this.zz2I) {
                this.zz2O.seek(this.zz2M);
                this.zz2O.write(this.buffer, 0, this.zz2K);
            }
            return;
        }
        finally {
            this.zz2O.close();
        }
    }

    public final void seek(long pos) throws IOException {
        if (pos >= this.zz2M && pos < this.zz2L) {
            this.zz2N = pos;
            return;
        }
        if (this.zz2I) {
            this.flush();
        }
        this.zz2M = pos;
        this.zz2N = pos;
        this.zz2K = this.zzZ(pos, this.buffer, 0, this.buffer.length);
        if (this.zz2K < 0) {
            this.zz2K = 0;
            this.zz2J = true;
        } else {
            this.zz2J = false;
        }
        this.zz2L = this.zz2M + (long)this.zz2K;
    }

    public final long getFilePointer() throws IOException {
        return this.zz2N;
    }

    public final long length() throws IOException {
        long l = this.zz2O.length();
        if (l < this.zz2L) {
            return this.zz2L;
        }
        return l;
    }

    public final void setLength(long newLength) throws IOException {
        if (this.zz2I) {
            this.flush();
        }
        this.zz2O.setLength(newLength);
        if (this.zz2N > newLength) {
            this.seek(newLength);
        }
    }

    public final void flush() throws IOException {
        if (this.zz2I) {
            this.zz2O.seek(this.zz2M);
            this.zz2O.write(this.buffer, 0, this.zz2K);
            this.zz2I = false;
        }
    }

    public final int read() throws IOException {
        while (this.zz2N >= this.zz2L) {
            if (this.zz2J) {
                return -1;
            }
            this.seek(this.zz2N);
        }
        return this.buffer[(int)(this.zz2N++ - this.zz2M)] & 0xFF;
    }

    private int zzI(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        while (true) {
            if (this.zz2J) {
                return -1;
            }
            n3 = (int)(this.zz2L - this.zz2N);
            if (n3 > 0) break;
            this.seek(this.zz2N);
        }
        int n4 = n3 >= n2 ? n2 : n3;
        System.arraycopy(this.buffer, (int)(this.zz2N - this.zz2M), byArray, n, n4);
        this.zz2N += (long)n4;
        if (n4 < n2) {
            int n5 = n2 - n4;
            if (n5 > this.buffer.length) {
                n5 = this.zzZ(this.zz2N, byArray, n + n4, n2 - n4);
            } else {
                this.seek(this.zz2N);
                if (!this.zz2J) {
                    n5 = n5 > this.zz2K ? this.zz2K : n5;
                    System.arraycopy(this.buffer, 0, byArray, n + n4, n5);
                } else {
                    n5 = -1;
                }
            }
            if (n5 > 0) {
                this.zz2N += (long)n5;
                return n4 + n5;
            }
        }
        return n4;
    }

    private int zzZ(long l, byte[] byArray, int n, int n2) throws IOException {
        this.zz2O.seek(l);
        int n3 = this.zz2O.read(byArray, n, n2);
        return n3;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.zzI(b, off, len);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int n;
        for (int i = 0; i < len; i += n) {
            zz2B zz2B2 = this;
            byte[] byArray = b;
            int n2 = off + i;
            int n3 = len - i;
            n = zz2B2.zzI(byArray, n2, n3);
            if (n >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        zz2B zz2B2 = this;
        this.seek(zz2B2.zz2N + (long)n);
        return n;
    }

    @Override
    public final void write(int b) throws IOException {
        while (true) {
            if (this.zz2N >= this.zz2M && this.zz2N < this.zz2M + (long)this.buffer.length) {
                this.buffer[(int)(this.zz2N - this.zz2M)] = (byte)b;
                this.zz2I = true;
                if (this.zz2N >= this.zz2L) {
                    ++this.zz2K;
                    ++this.zz2L;
                }
                ++this.zz2N;
                return;
            }
            this.seek(this.zz2N);
        }
    }

    private void zzU(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < this.buffer.length) {
            long l;
            int n3 = 0;
            int n4 = 0;
            if (this.zz2N >= this.zz2M) {
                n3 = (int)(this.zz2M + (long)this.buffer.length - this.zz2N);
            }
            if (n3 > 0) {
                n4 = n3 > n2 ? n2 : n3;
                System.arraycopy(byArray, n, this.buffer, (int)(this.zz2N - this.zz2M), n4);
                this.zz2I = true;
                l = this.zz2N + (long)n4;
                this.zz2L = l > this.zz2L ? l : this.zz2L;
                this.zz2K = (int)(this.zz2L - this.zz2M);
                this.zz2N += (long)n4;
            }
            if (n4 < n2) {
                this.seek(this.zz2N);
                System.arraycopy(byArray, n + n4, this.buffer, (int)(this.zz2N - this.zz2M), n2 - n4);
                this.zz2I = true;
                l = this.zz2N + (long)(n2 - n4);
                this.zz2L = l > this.zz2L ? l : this.zz2L;
                this.zz2K = (int)(this.zz2L - this.zz2M);
                this.zz2N += (long)(n2 - n4);
            }
            return;
        }
        this.flush();
        this.zz2K = 0;
        this.zz2L = 0L;
        this.zz2M = 0L;
        this.zz2O.seek(this.zz2N);
        this.zz2O.write(byArray, n, n2);
        this.zz2N += (long)n2;
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.zzU(b, 0, b.length);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.zzU(b, off, len);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    @Override
    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    @Override
    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) != -1 && n != 10) {
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)v & 0xFF);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            this.write(c >>> 8 & 0xFF);
            this.write(c & 0xFF);
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        char c;
        int n;
        int n2 = str.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            c = str.charAt(n);
            if (c > '\u0000' && c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(n3 >>> 8 & 0xFF);
        this.write(n3 & 0xFF);
        for (n = 0; n < n2; ++n) {
            c = str.charAt(n);
            if (c > '\u0000' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c & 0x3F);
                continue;
            }
            this.write(0xC0 | c >> 6 & 0x1F);
            this.write(0x80 | c & 0x3F);
        }
    }

    public final String toString() {
        return "fp=" + this.zz2N + ", bs=" + this.zz2M + ", de=" + this.zz2L + ", ds=" + this.zz2K + ", bl=" + this.buffer.length + ", m=" + this.mode + ", bm=" + this.zz2I;
    }
}

