/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzZ;
import com.aspose.words.internal.zzZ4C;
import com.aspose.words.internal.zzZVI;
import com.aspose.words.internal.zzZW7;
import com.aspose.words.internal.zzZWP;
import com.aspose.words.internal.zzZWV;
import com.aspose.words.internal.zzZWW;
import com.aspose.words.internal.zzZWX;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class zzZXC
extends zzZWV
implements zzZWP {
    private static final char[] zzXEM = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected final byte[] data;
    protected final int zzXEL;

    public zzZXC(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (byArray.length == 0 && n != 0) {
            throw new IllegalArgumentException("zero length data with non-zero pad bits");
        }
        if (n > 7 || n < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        this.data = zzZ.zzK(byArray);
        this.zzXEL = n;
    }

    @Override
    public final String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        zzZWX zzZWX2 = new zzZWX(byteArrayOutputStream);
        try {
            zzZWX2.zzX(this);
        }
        catch (IOException iOException) {
            throw new zzZWW("Internal error encoding BitString: " + iOException.getMessage(), iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (int i = 0; i != byArray.length; ++i) {
            stringBuffer.append(zzXEM[byArray[i] >>> 4 & 0xF]);
            stringBuffer.append(zzXEM[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public final int intValue() {
        int n = 0;
        byte[] byArray = this.data;
        if (this.zzXEL > 0 && this.data.length <= 4) {
            byArray = zzZXC.zzE(this.data, this.zzXEL);
        }
        for (int i = 0; i != byArray.length && i != 4; ++i) {
            n |= (byArray[i] & 0xFF) << i * 8;
        }
        return n;
    }

    public final byte[] zzZ3f() {
        if (this.zzXEL != 0) {
            throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
        }
        return zzZ.zzK(this.data);
    }

    public final byte[] getBytes() {
        return zzZXC.zzE(this.data, this.zzXEL);
    }

    public final int zzZ3e() {
        return this.zzXEL;
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return this.zzXEL ^ zzZ.hashCode(this.getBytes());
    }

    @Override
    protected final boolean zzZ(zzZWV zzZWV2) {
        if (!(zzZWV2 instanceof zzZXC)) {
            return false;
        }
        zzZXC zzZXC2 = (zzZXC)zzZWV2;
        return this.zzXEL == zzZXC2.zzXEL && zzZ.zzZ(this.getBytes(), zzZXC2.getBytes());
    }

    protected static byte[] zzE(byte[] byArray, int n) {
        byte[] byArray2 = zzZ.zzK(byArray);
        if (n > 0) {
            int n2 = byArray.length - 1;
            byArray2[n2] = (byte)(byArray2[n2] & 255 << n);
        }
        return byArray2;
    }

    static zzZXC zzZ(int n, InputStream inputStream) throws IOException {
        if (n <= 0) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int n2 = inputStream.read();
        byte[] byArray = new byte[n - 1];
        if (byArray.length != 0) {
            if (zzZ4C.readFully(inputStream, byArray) != byArray.length) {
                throw new EOFException("EOF encountered in middle of BIT STRING");
            }
            if (n2 > 0 && n2 < 8 && byArray[byArray.length - 1] != (byte)(byArray[byArray.length - 1] & 255 << n2)) {
                return new zzZVI(byArray, n2);
            }
        }
        return new zzZW7(byArray, n2);
    }

    @Override
    final zzZWV zzZ3d() {
        return new zzZW7(this.data, this.zzXEL);
    }

    @Override
    final zzZWV zzZ3c() {
        return new zzZVI(this.data, this.zzXEL);
    }

    @Override
    abstract void zzZ(zzZWX var1) throws IOException;
}

