/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zz8D;
import com.aspose.words.internal.zzZ;
import com.aspose.words.zzB7;
import com.aspose.words.zzCA;
import com.aspose.words.zzDS;
import com.aspose.words.zzED;
import com.aspose.words.zzIM;
import com.aspose.words.zzJ7;
import com.aspose.words.zzJA;
import com.aspose.words.zzK2;
import com.aspose.words.zzM5;
import com.aspose.words.zzZRP;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzM5 zzZVt;

    ChartSeriesCollection(zzM5 dmlChart) {
        this.zzZVt = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZVt.zzld().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZVt.zzld().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZVt.zzld().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZVt.zzld().clear();
        this.zzZ2(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, values);
        chartSeries.zztP().zzZ(ChartSeriesCollection.zzR(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, yValues);
        chartSeries.zztP().zzZ(ChartSeriesCollection.zzY(xValues));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        double[] dArray = values;
        zz8D[] zz8DArray = zz8D.zzZ(dates);
        String string = seriesName;
        ChartSeriesCollection chartSeriesCollection = this;
        if (zz8DArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zz8DArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zz8DArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = chartSeriesCollection.zzZ(string, dArray);
        chartSeries.zztP().zzZ(ChartSeriesCollection.zzZ(zz8DArray));
        if (chartSeriesCollection.zzZVt.zzmb() != 5) {
            chartSeriesCollection.zzZ2(true);
        }
        return chartSeries;
    }

    private void zzZ2(boolean bl) {
        zzZRP zzZRP2 = zzZ.zzZ((Object)this.zzZVt, zzZRP.class);
        if (zzZRP2 != null && zzZRP2.zzm8().getType() == 0) {
            zzZRP2.zzm8().zzuV().zzN(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzZVt.zzmb() != 15) {
            this.zzZVt.zzT(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, yValues);
        chartSeries.zztV().zzu6().zzN(3, this.zzZVt.zzla());
        chartSeries.zztP().zzZ(ChartSeriesCollection.zzY(xValues));
        if (bubbleSizes != null) {
            chartSeries.zztL().zzZ(ChartSeriesCollection.zzY(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzZ(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzZVt);
        chartSeries.setName(string);
        ChartSeries chartSeries2 = chartSeries;
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeries2.zztV().zzu6().zzN(5, new zzJA());
        switch (chartSeriesCollection.zzZVt.zzmb()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzZ(chartSeries2, 5);
                break;
            }
            case 4: {
                ChartSeriesCollection.zzZ(chartSeries2, 5);
                ChartSeriesCollection.zzU(chartSeries2);
                break;
            }
            case 6: {
                ChartSeriesCollection.zzZ(chartSeries2, 1);
                ChartSeriesCollection.zzU(chartSeries2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeries chartSeries3 = chartSeries2;
                zzJA zzJA2 = new zzJA();
                zzJA2.zzY(new zzDS());
                zzCA zzCA2 = new zzCA();
                zzCA2.setValue(1);
                zzJA2.zzmX().zzY(new zzB7(zzCA2));
                zzJA2.zzmX().zzYW(19050.0);
                chartSeries3.zztV().zzu6().zzN(5, zzJA2);
            }
        }
        chartSeries.setIndex(this.zzZVt.zzld().size());
        chartSeries.zzT5(chartSeries.getIndex());
        chartSeries.zztN().zzZ(ChartSeriesCollection.zzY(dArray));
        chartSeries.zztO().zzZ(chartSeries.zztN().zzk2());
        this.zzZVt.zzT(chartSeries);
        return chartSeries;
    }

    private static void zzU(ChartSeries chartSeries) {
        zzJA zzJA2 = new zzJA();
        zzJA2.zzY(new zzDS());
        zzJA2.zzmX().zzY(new zzED());
        zzJA2.zzmX().setEndCap(0);
        zzJA2.zzmX().zzYW(19050.0);
        chartSeries.zztV().zzu6().zzN(5, zzJA2);
    }

    private static void zzZ(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker();
        chartMarker.zztX().zzN(0, n);
        chartSeries.zztV().zzu6().zzN(4, chartMarker);
    }

    private static zzIM zzY(double[] dArray) {
        int n = 0;
        zzIM zzIM2 = new zzIM(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzIM2.zzX(new zzK2(n, d, "General"));
            }
            ++n;
        }
        zzIM2.zzQS(dArray.length);
        zzIM2.zzfb();
        return zzIM2;
    }

    private static zzIM zzZ(zz8D[] zz8DArray) {
        int n = 0;
        zzIM zzIM2 = new zzIM(2, false);
        zz8D[] zz8DArray2 = zz8DArray;
        int n2 = zz8DArray.length;
        for (int i = 0; i < n2; ++i) {
            zz8D zz8D2 = zz8DArray2[i];
            zzIM2.zzX(new zzK2(n++, zz8D2.zzDD(), "m/d/yyyy"));
        }
        zzIM2.zzQS(zz8DArray.length);
        zzIM2.zzfb();
        return zzIM2;
    }

    private static zzIM zzR(String[] stringArray) {
        int n = 0;
        zzIM zzIM2 = new zzIM(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzIM2.zzX(new zzJ7(n++, string));
        }
        zzIM2.zzQS(stringArray.length);
        zzIM2.zzfb();
        return zzIM2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZVt.zzld().size();
    }
}

