/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz2C;
import com.aspose.words.internal.zz74;
import com.aspose.words.internal.zz76;
import com.aspose.words.internal.zz77;
import com.aspose.words.internal.zzJ0;
import com.aspose.words.internal.zzJ2;
import com.aspose.words.internal.zzJ4;
import com.aspose.words.internal.zzRR;
import com.aspose.words.internal.zzV9;
import com.aspose.words.internal.zzZ;
import com.aspose.words.internal.zzZQV;
import com.aspose.words.zz14;
import com.aspose.words.zzNX;
import com.aspose.words.zzYOX;
import com.aspose.words.zzYYJ;
import com.aspose.words.zzZ86;
import com.aspose.words.zzZ87;
import com.aspose.words.zzZ88;
import com.aspose.words.zzZ89;
import com.aspose.words.zzZAN;
import com.aspose.words.zzZAQ;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzZ(zz74 zz742, zz74 zz743, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        Object object;
        Object object2;
        zzZ.zzZ((Object)zz742, "srcStream");
        zzZ.zzZ((Object)zz743, "dstStream");
        zzZ.zzZ((Object)certificateHolder, "certHolder");
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            object2 = digitalSignature;
            object = signOptions;
            ((DigitalSignature)object2).setComments(((SignOptions)object).getComments());
            ((DigitalSignature)object2).zzC(((SignOptions)object).zzmD());
            ((DigitalSignature)object2).zzR(((SignOptions)object).zzZi5());
            ((DigitalSignature)object2).setImageBytes(((SignOptions)object).getSignatureLineImage());
            ((DigitalSignature)object2).zzQ(((SignOptions)object).zzZi4());
        }
        if (zz14.zz7(zz742)) {
            DigitalSignatureUtil.zzZ(zz742, zz743, digitalSignature, true);
            return;
        }
        zz14 zz142 = new zz14();
        zz74 zz744 = zz742;
        zz14 zz143 = zz142;
        FileFormatInfo fileFormatInfo = zz142.zzY(zz744, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzRR zzRR2 = new zzRR(zz742);
                int n = fileFormatInfo.zzZUW() == 1 ? 1 : 2;
                zzYYJ.zzZ(zzRR2, digitalSignature, n);
                zz743.setLength(0L);
                zzRR2.zzP(zz743);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string;
                    String string2 = string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignature digitalSignature2 = digitalSignature;
                    object2 = zz743;
                    object = fileFormatInfo.zzZUV();
                    zz76 zz762 = DigitalSignatureUtil.zzZ((zzRR)object, string2);
                    zz76 zz763 = new zz76();
                    DigitalSignatureUtil.zzZ((zz74)zz762, (zz74)zz763, digitalSignature2, false);
                    zzRR zzRR3 = zzNX.zzY(zz763, string2);
                    zzRR3.zzP((zz74)object2);
                    return;
                }
                DigitalSignatureUtil.zzZ(zz742, zz743, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignature digitalSignature3 = digitalSignature;
                object2 = zz743;
                object = zz742;
                zzZAQ zzZAQ2 = new zzZAQ((zz74)object);
                zzZAN zzZAN2 = new zzZAN(zzZAQ2);
                zzZAN2.zzY(digitalSignature3);
                ((zz74)object2).setLength(0L);
                zzZAQ2.zzX((zz74)object2, "application/vnd.oasis.opendocument.text");
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzZ((zz74)zz74.zzY(srcStream), (zz74)zz74.zzY(dstStream), certHolder, signOptions);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzZ.zzZ(srcFileName, "srcFileName");
        zzZ.zzZ(dstFileName, "dstFileName");
        zz77 zz772 = zzZ.zzZ(srcFileName, 3, 1);
        try {
            zz77 zz773 = zzZ.zzZ(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzZ((zz74)zz772, (zz74)zz773, certHolder, signOptions);
            }
            finally {
                zz773.close();
            }
            return;
        }
        finally {
            zz772.close();
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zz2C zz2C2 = zz74.zzY(dstStream);
        zz76 zz762 = zz74.zzY(srcStream);
        DigitalSignatureUtil.zzZ((zz74)zz762, (zz74)zz2C2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        zz77 zz772 = zzZ.zzZ(srcFileName, 3, 1);
        try {
            zz77 zz773 = zzZ.zzZ(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzW(zz772, zz773);
            }
            finally {
                zz773.close();
            }
            return;
        }
        finally {
            zz772.close();
        }
    }

    private static void zzW(zz74 zz742, zz74 zz743) throws Exception {
        zz14 zz142 = new zz14();
        zz74 zz744 = zz742;
        zz14 zz143 = zz142;
        FileFormatInfo fileFormatInfo = zz142.zzY(zz744, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzRR zzRR2 = new zzRR(zz742);
                zzRR2.zzQZ().remove("_xmlsignatures");
                zzRR2.zzQZ().remove("_signatures");
                zz743.zzx(0L);
                zzRR2.zzP(zz743);
                zz743.setLength(zz743.getPosition());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzJ4 zzJ42 = new zzJ4(zz742);
                zzJ2 zzJ22 = zzJ42.zzZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzJ22 != null) {
                    for (zzJ0 zzJ02 : zzJ22.zzKJ()) {
                        String string = zzJ22.zzZ(zzJ02);
                        zzJ42.zzKK().remove(string);
                    }
                    zzJ42.zzKK().remove(zzJ22.getName());
                    zzJ0 zzJ03 = zzJ42.zzKJ().zzZ9("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzJ42.zzKJ().remove(zzJ03.getId());
                    zzJ42.zzKM();
                }
                zz743.zzx(0L);
                zzJ42.zzP(zz743);
                zz743.setLength(zz743.getPosition());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzW(zz74.zzY(srcStream), zz74.zzY(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        zz77 zz772 = zzZ.zzZ(fileName, 3, 1);
        try {
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzc(zz772);
            return digitalSignatureCollection;
        }
        finally {
            zz772.close();
        }
    }

    private static DigitalSignatureCollection zzc(zz74 zz742) throws Exception {
        if (zz14.zz7(zz742)) {
            zz74 zz743 = zz742;
            zz743.zzx(0L);
            zzJ4 zzJ42 = new zzJ4(zz743);
            DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
            zzJ2 zzJ22 = zzJ42.zzZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
            if (zzJ22 != null) {
                for (zzJ0 zzJ02 : zzJ22.zzKJ()) {
                    String string = zzJ22.zzZ(zzJ02);
                    zzJ2 zzJ23 = zzJ42.zzZe(string);
                    zzJ2 zzJ24 = zzJ42.zzZ(zzJ23, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                    zzZQV zzZQV2 = zzV9.zzz(zzJ24.zzKH().toArray());
                    zzYOX.zzZ(zzJ23.zzVB(), zzZQV2, new zzZ89(zzJ42), digitalSignatureCollection, null);
                }
            }
            return digitalSignatureCollection;
        }
        zz14 zz142 = new zz14();
        zz74 zz744 = zz742;
        zz14 zz143 = zz142;
        FileFormatInfo fileFormatInfo = zz142.zzY(zz744, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zz742);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzc(zz74.zzY(stream));
    }

    static zz76 zzZ(zzRR zzRR2, String string) throws Exception {
        zzNX zzNX2 = new zzNX(zzRR2);
        if (zzNX2.zznb()) {
            zz76 zz762 = zzNX2.zzVc(string);
            return zz762;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    private static void zzZ(zz74 zz742, zz74 zz743, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzJ4 zzJ42 = new zzJ4(zz742);
        zzZ88 zzZ882 = bl ? new zzZ86(zzJ42) : new zzZ87(zzJ42);
        zzZ882.zzY(digitalSignature);
        zz743.setLength(0L);
        zzJ42.zzP(zz743);
    }
}

