/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.List;
import com.aspose.words.ListCollection;
import com.aspose.words.ListLevel;
import com.aspose.words.Paragraph;
import com.aspose.words.internal.zzZ;
import com.aspose.words.zzX;
import com.aspose.words.zzZOR;
import com.aspose.words.zzZP0;

public class ListFormat {
    private zzZP0 zzYPh;
    private zzZOR zzYPg;
    private ListCollection zzZot;
    private ListLevel zzYPf;
    private ListLevel zzYPe;

    ListFormat(zzZP0 parentParaAttrs, zzZOR parentRunAttrs, ListCollection lists) {
        this.zzYPh = parentParaAttrs;
        this.zzYPg = parentRunAttrs;
        this.zzZot = lists;
    }

    public void applyBulletDefault() {
        if (this.zzZot.getCount() > 2046) {
            zzX.zzY(this.zzZot.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        this.zzIm(this.zzZot.add(0).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat = this;
        this.zzYPf = null;
    }

    public void applyNumberDefault() {
        if (this.zzZot.getCount() > 2046) {
            zzX.zzY(this.zzZot.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        this.zzIm(this.zzZot.add(6).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat = this;
        this.zzYPf = null;
    }

    public void removeNumbers() {
        this.setList(null);
        ListFormat listFormat = this;
        this.zzYPf = null;
    }

    public void listIndent() {
        if (this.getListLevelNumber() < 8) {
            this.setListLevelNumber(this.getListLevelNumber() + 1);
            ListFormat listFormat = this;
            this.zzYPf = null;
        }
    }

    public void listOutdent() {
        if (this.getListLevelNumber() > 0) {
            this.setListLevelNumber(this.getListLevelNumber() - 1);
            ListFormat listFormat = this;
            this.zzYPf = null;
        }
    }

    public int getListLevelNumber() {
        return (Integer)this.zzYPh.fetchParaAttr(1110);
    }

    public void setListLevelNumber(int value) {
        this.zzYPh.setParaAttr(1110, value);
        ListFormat listFormat = this;
        this.zzYPf = null;
    }

    final int zzZHl() {
        Paragraph paragraph = zzZ.zzZ((Object)this.zzYPh, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzYo(1110, 1);
        }
        return this.getListLevelNumber();
    }

    public boolean isListItem() {
        return this.getListId() != 0;
    }

    public List getList() {
        int n = this.getListId();
        if (n != 0) {
            return this.zzZot.zzIg(n);
        }
        return null;
    }

    public void setList(List value) {
        if (value == null) {
            this.zzIm(0);
            this.setListLevelNumber(0);
        } else {
            if (value.getDocument() != this.zzZot.getDocument()) {
                throw new IllegalArgumentException("The list belongs to a different document.");
            }
            if (value.isListStyleDefinition()) {
                throw new IllegalArgumentException("The list is a definition of a list style.");
            }
            this.zzIm(value.getListId());
        }
        ListFormat listFormat = this;
        this.zzYPf = null;
    }

    final List zzZHk() {
        ListFormat listFormat = this;
        Paragraph paragraph = zzZ.zzZ((Object)listFormat.zzYPh, Paragraph.class);
        int n = paragraph != null ? ((Integer)paragraph.zzYo(1120, 1)).intValue() : listFormat.getListId();
        if (n != 0) {
            return this.zzZot.zzIg(n);
        }
        return null;
    }

    public ListLevel getListLevel() {
        try {
            if (this.zzYPf == null) {
                List list = this.getList();
                ListLevel listLevel = list != null ? list.zzIh(this.getListLevelNumber()) : null;
                this.zzYPf = listLevel != null ? new ListLevel(listLevel, this.zzYPg) : null;
            }
            return this.zzYPf;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final ListLevel zzZHj() {
        if (this.zzYPe == null) {
            List list = this.zzZHk();
            ListLevel listLevel = list != null ? list.zzIh(this.zzZHl()) : null;
            this.zzYPe = listLevel != null ? new ListLevel(listLevel, this.zzYPg) : null;
        }
        return this.zzYPe;
    }

    final int getListId() {
        return (Integer)this.zzYPh.fetchParaAttr(1120);
    }

    private void zzIm(int n) {
        this.zzYPh.setParaAttr(1120, n);
        ListFormat listFormat = this;
        this.zzYPf = null;
        if (n == 0 || this.zzYPh.getDirectParaAttr(1160) == null || this.getListLevel() == null) {
            return;
        }
        int n2 = (Integer)this.zzYPh.getDirectParaAttr(1160);
        if (n2 == 0) {
            this.zzYPh.removeParaAttr(1160);
            return;
        }
        int n3 = n2 + this.getListLevel().zzZRN().zzZFE() + this.getListLevel().zzZRN().zzZFH();
        this.zzYPh.setParaAttr(1160, n3);
    }
}

