/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.internal.zz2K;
import com.aspose.words.internal.zz8F;
import com.aspose.words.internal.zzZ;
import com.aspose.words.zzX;
import com.aspose.words.zzYSY;
import com.aspose.words.zzZPD;
import com.aspose.words.zzZQV;
import com.aspose.words.zzZWL;

public abstract class Node
implements Cloneable {
    private Node zzYDp;
    private Node zzYDo;
    private Node zzYDn;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzY(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYDp == null) {
            return null;
        }
        if (this.zzYDp.getNodeType() == 36) {
            return null;
        }
        return (CompositeNode)this.zzYDp;
    }

    final CompositeNode zzZAT() {
        if (zzX.zzF(this.getParentNode())) {
            return this.getParentNode().zzZAT();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this instanceof DocumentBase) {
            return (DocumentBase)this;
        }
        if (this.zzYDp == null) {
            return null;
        }
        return this.zzYDp.getDocument();
    }

    final Document zzZAS() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzZAR() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zz6h();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzYDn;
    }

    final Node zzZAQ() {
        Node node = this;
        while ((node = node.getPreviousSibling()) != null && zzX.zzN(node)) {
        }
        return node;
    }

    final Node zzZAP() {
        Node node = zzX.zzW(this.getPreviousSibling(), false);
        if (node == null && zzX.zzF(this.getParentNode())) {
            node = this.getParentNode().zzZAP();
        }
        return node;
    }

    final Node zzZAO() {
        Node node = zzX.zzX(this.getNextSibling(), false);
        if (node == null && zzX.zzF(this.getParentNode())) {
            node = this.getParentNode().zzZAO();
        }
        return node;
    }

    final CompositeNode zzZAN() {
        Node node = this;
        while ((node = node.zzZAP()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzZAM() {
        Node node = this;
        while ((node = node.zzZAO()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzYDo;
    }

    final Node zzZAL() {
        Node node = this;
        while ((node = node.getNextSibling()) != null && zzX.zzN(node)) {
        }
        return node;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzZAK() {
        return this.getParentNode() == null || this == this.getParentNode().getLastChild();
    }

    final boolean isFirstChild() {
        return this.getParentNode() == null || this == this.getParentNode().getFirstChild();
    }

    final boolean zzZAJ() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzX.zzP(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzZAI() {
        return this.zzYDo;
    }

    final void zzZ8(Node node) {
        this.zzYDo = node;
    }

    final Node zzZAH() {
        return this.zzYDn;
    }

    final void zzZ7(Node node) {
        this.zzYDn = node;
    }

    final Node zzZAG() {
        Node node = this;
        if (node.zzYDo != null) {
            node = this;
            return node.zzYDo;
        }
        return this.getParentNode();
    }

    final int zzZAF() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzX.zzH(this);
        boolean bl2 = zzX.zzL(this);
        boolean bl3 = zzX.zzI(this);
        boolean bl4 = zzX.zzJ(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzZAF() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 36;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzZAF() != 3 && n2 != 6 && n != 27 && n != 33)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzZ(isCloneChildren, null);
    }

    Node zzZ(boolean bl, zzZPD zzZPD2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYDp != null) {
            node.zzYDp = this.getDocument().zz50();
        }
        node.zzYDo = null;
        node.zzYDn = null;
        if (zzZPD2 != null) {
            zzZPD2.zzT(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzV(StringBuilder stringBuilder) {
        zzZ.zzY(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isAssignableFrom(compositeNode.getClass())) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZ6(Node node) {
        this.zzYDp = node != null ? node : this.getDocument().zz50();
    }

    final void zzY(DocumentBase documentBase) {
        this.zzYDp = documentBase != null ? documentBase.zz50() : null;
    }

    final boolean zzZ5(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzFN(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzFM(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzU7(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzZQV zzZQV2;
        int n = saveFormat;
        switch (n) {
            case 50: {
                zzZQV2 = new zzZWL();
                break;
            }
            case 70: {
                zzZQV2 = new zzYSY();
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZQV zzZQV3 = zzZQV2;
        return zzZQV2.zzZl(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZQV zzZQV2;
        SaveOptions saveOptions2 = saveOptions;
        switch (saveOptions2.getSaveFormat()) {
            case 50: {
                zzZQV2 = new zzZWL((HtmlSaveOptions)saveOptions2);
                break;
            }
            case 70: {
                zzZQV2 = new zzYSY((TxtSaveOptions)saveOptions2);
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZQV zzZQV3 = zzZQV2;
        return zzZQV2.zzZl(this);
    }

    final Node zzFL(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzX.zzM(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final boolean zzZ4(Node node) {
        Node node2;
        zz8F<Node> zz8F2;
        zz8F<Node> zz8F3;
        Node node3 = node;
        Node node4 = this;
        if (node4 == null || node3 == null) {
            return false;
        }
        zz8F<Node> zz8F4 = Node.zzZ3(node4);
        zz8F<Node> zz8F5 = zz8F3 = Node.zzZ3(node3);
        zz8F<Node> zz8F6 = zz8F4;
        Node node5 = null;
        while (zz8F6.peek() == zz8F5.peek()) {
            node5 = (Node)zz8F6.pop();
            zz8F5.pop();
            zz8F2 = zz8F6;
            if (zz8F2.size() != 0 && (zz8F2 = zz8F5).size() != 0) continue;
        }
        if ((node2 = node5) != null) {
            zz8F2 = zz8F4;
            if (zz8F2.size() == 0 || (zz8F2 = zz8F3).size() == 0) {
                zz8F2 = zz8F3;
                boolean bl = zz8F2.size() > 0;
                return bl;
            }
            Object e = zz8F4.peek();
            Object e2 = zz8F3.peek();
            for (Node node6 : ((CompositeNode)node2).getChildNodes()) {
                if (node6 == e) {
                    return true;
                }
                if (node6 != e2) continue;
            }
        }
        return false;
    }

    final boolean isRemoved() {
        return this.getAncestor(1) == null;
    }

    private static zz8F<Node> zzZ3(Node node) {
        zz8F<Node> zz8F2 = new zz8F<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zz8F2.push(node2);
        }
        return zz8F2;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "GlossaryDocument";
            }
            case 30: {
                return "BuildingBlock";
            }
            case 31: {
                return "CommentRangeStart";
            }
            case 32: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 33: {
                return "OfficeMath";
            }
            case 34: {
                return "SubDocument";
            }
            case 35: {
                return "System";
            }
            case 36: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = Node.nodeTypeToString(this.getNodeType());
        Node node = this;
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node2 = node; node2 != null && node2.getParentNode() != null; node2 = node2.getParentNode()) {
            int n = 0;
            for (Node node3 = node2.getParentNode().getFirstChild(); node3 != null && node3 != node2; node3 = node3.getNextSibling()) {
                ++n;
            }
            zzZ.zzZ(stringBuilder, "{0}{1}", node2 == node ? "" : ".", n);
        }
        objectArray[1] = zz2K.trim(stringBuilder.toString());
        return zz2K.trim(zz2K.format("{0} {1}", objectArray));
    }

    public void dd() {
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

