/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Story;
import com.aspose.words.zzYZJ;
import com.aspose.words.zzZOP;
import com.aspose.words.zzZPD;

public final class Section
extends CompositeNode<Node>
implements zzZOP {
    private zzYZJ zzYvU;
    private PageSetup zzY8x;
    private HeaderFooterCollection zzY8w;

    public Section(DocumentBase doc) {
        this(doc, new zzYZJ());
    }

    Section(DocumentBase doc, zzYZJ sectPr) {
        super(doc);
        this.zzYvU = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzY8w == null) {
            this.zzY8w = new HeaderFooterCollection(this);
        }
        return this.zzY8w;
    }

    public final PageSetup getPageSetup() {
        if (this.zzY8x == null) {
            this.zzY8x = new PageSetup(this, this.getDocument().zz4S(), this.getDocument().getStyles(), new zzZ(this));
        }
        return this.zzY8x;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZsL();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzSV(!value);
    }

    final zzYZJ zzZx0() {
        return this.zzYvU;
    }

    final void zzY(zzYZJ zzYZJ2) {
        this.zzYvU = zzYZJ2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzZ(boolean bl, zzZPD zzZPD2) {
        zzYZJ zzYZJ2;
        Section section = (Section)super.zzZ(bl, zzZPD2);
        section.zzYvU = zzYZJ2 = (zzYZJ)this.zzYvU.zzyO();
        section.zzY8x = null;
        section.zzY8w = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzW(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzW(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzAK(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzh(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzAK(n) == null;
            }
        }
        return false;
    }

    private void zzW(Section section, boolean bl) {
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        Paragraph paragraph = bl ? body2.getLastParagraph() : null;
        body2.zzY(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzYvU.zzTK(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zz4S().zzZra.zzTJ(key);
        }
        return zzYZJ.zzTk(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzYvU.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zz4S().zzZra.zzT(key, value);
            return;
        }
        this.zzYvU.zzT(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzYvU.clear();
    }

    final boolean zzZkm() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzZkl() {
        return this.getParentNode().getLastChild() == this;
    }

    static final class zzZ
    implements zzZOP {
        private Section zzYvE;

        zzZ(Section section) {
            this.zzYvE = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzZkk().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzZkk().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzZkk().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZOP zzZkk() {
            Document document = com.aspose.words.internal.zzZ.zzZ((Object)this.zzYvE.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzYvE;
        }
    }
}

